(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     11500,        439]*)
(*NotebookOutlinePosition[     12347,        466]*)
(*  CellTagsIndexPosition[     12303,        462]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.
Make modifications to any definition using commands in the Format menu.\
\>", 
  "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  CellBracketOptions->{"Color"->RGBColor[0.771908, 0.399634, 0.262867]},
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "ColorPrintout"],
  PageWidth->PaperWidth,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellMargins->{{36, 20}, {2, 10}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CellFrameMargins->{{100, 4}, {8, 10}},
  TextAlignment->Left,
  LineSpacing->{1, -5},
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontSize->60,
  FontSlant->"Italic",
  FontColor->RGBColor[0.620523, 0.66688, 0.409964]],

Cell[StyleData["Title", "Printout"],
  FontSize->48,
  FontColor->GrayLevel[0.4]],

Cell[StyleData["Title", "ColorPrintout"],
  FontSize->48]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{144, 20}, {2, 10}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontSize->24,
  FontSlant->"Italic",
  FontColor->RGBColor[0.326787, 0.658763, 0.400732]],

Cell[StyleData["Subtitle", "Printout"],
  FontSize->18,
  FontColor->GrayLevel[0.300008]],

Cell[StyleData["Subtitle", "ColorPrintout"],
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{144, 20}, {2, 2}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Printout"],
  FontSize->12],

Cell[StyleData["Subsubtitle", "ColorPrintout"],
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{0, 0}, {0, 0.25}},
  CellMargins->{{36, 20}, {10, 20}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->{{10, 4}, {6, 2}},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontSize->14,
  FontWeight->"Bold",
  FontColor->RGBColor[0.771908, 0.399634, 0.262867]],

Cell[StyleData["Section", "Printout"],
  FontSize->14,
  FontColor->GrayLevel[0.300008]],

Cell[StyleData["Section", "ColorPrintout"],
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{36, 20}, {Inherited, 18}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{2, 12}, {0, 12}},
  CellFrameLabelMargins->6,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Printout"]],

Cell[StyleData["Subsection", "ColorPrintout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[EmptySquare]",
  CellMargins->{{36, Inherited}, {Inherited, 12}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  CounterIncrements->"Subsubsection",
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData["Subsubsection", "Printout"]],

Cell[StyleData["Subsubsection", "ColorPrintout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellFrame->False,
  CellMargins->{{36, 20}, {4, 4}},
  CellFrameMargins->{{4, 10}, {6, 0}},
  CellFrameLabelMargins->4,
  LineSpacing->{1, 6},
  CounterIncrements->"Text"],

Cell[StyleData["Text", "Printout"],
  LineSpacing->{1, 5},
  FontSize->10],

Cell[StyleData["Text", "ColorPrintout"],
  LineSpacing->{1, 5},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{100, 38}, {4, 4}},
  LineSpacing->{1.25, 1},
  CounterIncrements->"SmallText",
  FontSize->10],

Cell[StyleData["SmallText", "Printout"],
  FontSize->9],

Cell[StyleData["SmallText", "ColorPrintout"],
  FontSize->9]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{36, 0}, {0, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{3, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->RGBColor[0.95021, 0.934356, 0.499062]],

Cell[StyleData["Input", "Printout"],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["Input", "ColorPrintout"],
  FontSize->10]
}, Closed]],

Cell[StyleData["InlineInput"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{36, 0}, {Inherited, 0}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{3, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Output",
  FontColor->GrayLevel[0],
  Background->RGBColor[0.620523, 0.66688, 0.409964]],

Cell[StyleData["Output", "Printout"],
  FontSize->10,
  Background->GrayLevel[0.8]],

Cell[StyleData["Output", "ColorPrintout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellDingbat->"\[LongDash]",
  CellMargins->{{64, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{3, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontSlant->"Oblique"],

Cell[StyleData["Message", "Printout"],
  FontSize->8],

Cell[StyleData["Message", "ColorPrintout"],
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{36, 20}, {3, 3}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{3, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  TextAlignment->Left,
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None,
  Background->RGBColor[0.967727, 0.972747, 0.534508]],

Cell[StyleData["Print", "Printout"],
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["Print", "ColorPrintout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{36, 0}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  Background->RGBColor[0.901915, 0.799634, 0.502861]],

Cell[StyleData["Graphics", "Printout"],
  FontSize->10,
  Background->GrayLevel[0.8]],

Cell[StyleData["Graphics", "ColorPrintout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0.551492, 0.231144, 0.313466]],

Cell[StyleData["CellLabel", "Printout"],
  FontSize->8,
  FontColor->GrayLevel[0]],

Cell[StyleData["CellLabel", "ColorPrintout"],
  FontSize->8]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0 Beta 3",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{485, 315},
WindowMargins->{{10, Automatic}, {Automatic, 5}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 52, "Subtitle"],
Cell[1771, 53, 193, 5, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 62, 42, 0, 50, "Section"],
Cell[2034, 64, 124, 2, 36, 31, 0, "StyleData", "All", "Working"],
Cell[2161, 68, 104, 2, 36, 32, 0, "StyleData", "All", "Printout"],
Cell[2268, 72, 109, 2, 36, 37, 0, "StyleData", "All", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2414, 79, 35, 0, 38, "Section"],
Cell[2452, 81, 101, 3, 30, "Text"],
Cell[2556, 86, 398, 10, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[2991, 101, 38, 0, 38, "Section"],

Cell[CellGroupData[{
Cell[3054, 105, 453, 12, 89, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[3510, 119, 81, 2, 75, 36, 0, "StyleData", "Title", "Printout"],
Cell[3594, 123, 57, 1, 75, 41, 0, "StyleData", "Title", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3688, 129, 357, 9, 54, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[4048, 140, 89, 2, 46, 39, 0, "StyleData", "Subtitle", "Printout"],
Cell[4140, 144, 60, 1, 46, 44, 0, "StyleData", "Subtitle", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4237, 150, 309, 8, 45, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[4549, 160, 58, 1, 33, 42, 0, "StyleData", "Subsubtitle", "Printout"],
Cell[4610, 163, 63, 1, 33, 47, 0, "StyleData", "Subsubtitle", "ColorPrintout"]

}, Closed]],

Cell[CellGroupData[{
Cell[4710, 169, 395, 10, 54, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[5108, 181, 88, 2, 62, 38, 0, "StyleData", "Section", "Printout"],
Cell[5199, 185, 59, 1, 62, 43, 0, "StyleData", "Section", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5295, 191, 370, 10, 45, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[5668, 203, 41, 0, 51, 41, 0, "StyleData", "Subsection", "Printout"],
Cell[5712, 205, 46, 0, 51, 46, 0, "StyleData", "Subsection", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5795, 210, 296, 8, 43, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[6094, 220, 44, 0, 43, 44, 0, "StyleData", "Subsubsection", "Printout"],
Cell[6141, 222, 49, 0, 43, 49, 0, "StyleData", "Subsubsection", 
"ColorPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6239, 228, 39, 0, 38, "Section"],

Cell[CellGroupData[{
Cell[6303, 232, 197, 6, 36, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[6503, 240, 74, 2, 35, 35, 0, "StyleData", "Text", "Printout"],
Cell[6580, 244, 79, 2, 35, 40, 0, "StyleData", "Text", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6696, 251, 140, 4, 43, 28, 0, "StyleData", "SmallText", "All",
  CounterIncrements->"SmallText"],
Cell[6839, 257, 55, 1, 34, 40, 0, "StyleData", "SmallText", "Printout"],
Cell[6897, 260, 60, 1, 34, 45, 0, "StyleData", "SmallText", "ColorPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7006, 267, 42, 0, 38, "Section"],
Cell[7051, 269, 248, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[7324, 278, 530, 15, 49, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[7857, 295, 87, 2, 46, 36, 0, "StyleData", "Input", "Printout"],
Cell[7947, 299, 57, 1, 46, 41, 0, "StyleData", "Input", "ColorPrintout"]
}, Closed]],
Cell[8019, 303, 375, 12, 45, 30, 0, "StyleData", "InlineInput", "All",
  CounterIncrements->"Input"],

Cell[CellGroupData[{
Cell[8419, 319, 517, 14, 48, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[8939, 335, 83, 2, 47, 37, 0, "StyleData", "Output", "Printout"],
Cell[9025, 339, 58, 1, 47, 42, 0, "StyleData", "Output", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9120, 345, 542, 16, 44, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[9665, 363, 53, 1, 32, 38, 0, "StyleData", "Message", "Printout"],
Cell[9721, 366, 58, 1, 32, 43, 0, "StyleData", "Message", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9816, 372, 528, 15, 59, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[10347, 389, 87, 2, 49, 36, 0, "StyleData", "Print", "Printout"],
Cell[10437, 393, 57, 1, 49, 41, 0, "StyleData", "Print", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10531, 399, 444, 12, 56, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics"],
Cell[10978, 413, 85, 2, 43, 39, 0, "StyleData", "Graphics", "Printout"],
Cell[11066, 417, 60, 1, 43, 44, 0, "StyleData", "Graphics", "ColorPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11163, 423, 149, 4, 42, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[11315, 429, 82, 2, 32, 40, 0, "StyleData", "CellLabel", "Printout"],
Cell[11400, 433, 60, 1, 32, 45, 0, "StyleData", "CellLabel", "ColorPrintout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

